;-------------------------------;
;	HODINY+TERMOSTAT v2	;
;-------------------------------;
;slovak@post.cz	      )S(11.2005;
;-------------------------------;
;Displej (LED 4 mstn)
;C	-teplota (-45 a 130C, krok 0.1)
;Hod.	-hodiny
;rEF.t.	-referenn teplota (-45 a 130C, krok 0.1)
;HYSt.	-hystereze (0 a 25.5, krok 0.1)
;1.CAS	-1.asov pepnut ref.teploty
;1.rEF.	-1.referenn teplota pro 1.CAS
;2.CAS	-2.asov pepnut ref.teploty
;2.rEF.	-2.referenn teplota pro 2.CAS
;3.CAS	-3.asov pepnut ref.teploty
;3.rEF.	-3.referenn teplota pro 3.CAS
;4.CAS	-4.asov pepnut ref.teploty
;4.rEF.	-4.referenn teplota pro 4.CAS
;ru.P.	-run provoz, run pepnn vstupu
;--------------------------------
;Tlatka
;Tl.S	-Set, nastavit	(lev)
;Tl.M	-Mnus		(prostedn)
;Tl.P	-Plus		(prav)
;--------------------------------
;Vstup Re, Regulace:
;Re=1 pi, teplota < referenn teplota
;Re=0 pi, teplota => referenn teplota + hystereze
;Re=0 pi, porucha snmae
;--------------------------------
;Teplotn idlo SMT 160-30
;--------------------------------
;Xtal 19.6608MHz
;--------------------------------

 LIST P=16F628, R=DEC		;Direktivy pekladae
 include<p16f628.inc>		;Definice nzv registr
 __CONFIG 0x3F46		;Nastav nsledujc konfiguraci
; CP:OFF, CPD:OFF, LVP:OFF, BOREN:ON,
; MCLRE:I/O, PWRTEN:Enable, WDTE:ON, OSC:HS

 cblock	0x20
MemStat
MemW
A1		;matematick
A2		; promnn
A3		; a jin funkce
B1		;
B2		;
B3		;
C1		;
C2		;
C3		;
D1		;
D2		;
D3		;
X1		;
X2		;
R1		;d jedniek pro pevod asu HEX/DEC
R10		;d destek pro pevod asu HEX/DEC
FL		;flag,pznaky
Znak0		;slo znaku v DIS4 pozice 0
Znak1		;slo znaku v DIS3 pozice 1
Znak2		;slo znaku v DIS2 pozice 2
Znak3		;slo znaku v DIS1 pozice 3
PZnak		;pro pevod slo/znak
Pozice		;slo zapnutho displeje
BLIK		;dli pro blikn displeje
KLVP		;slo stisknutho tlatka
KLVD		;dli pro ten tlatek
KLVO		;dli pro opakovn tlatka
De3		;dli /3
SEKD		;dli pro 1Hz
PV		;poet vzork
SH1		;sout rovn H
SH2		;
SH3		;
SP1		;souet periody P
SP2		;
SP3		;
T1		;teplota [C*10]
T2		;
Sek		;sekundy
Min	;00	;minuty
Hod	;01	;hodiny
RT1	;02	;referenn teplota
RT2	;03	;
FEE	;04	;flag ukldan do EEPROM
HYST	;05	;hystereze
CAS1H	;06	;1.as  hodiny
CAS1M	;07	;	minuty
REF11	;08	;1.referenn teplota pro 1.as
REF12	;09	;
CAS2H	;0A	;2.as  hodiny
CAS2M	;0B	;	minuty
REF21	;0C	;2.referenn teplota pro 2.as
REF22	;0D	;
CAS3H	;0E	;3.as  hodiny
CAS3M	;0F	;	minuty
REF31	;10	;3.referenn teplota pro 3.as
REF32	;11	;
CAS4H	;12	;4.as  hodiny
CAS4M	;13	;	minuty
REF41	;14	;4.referenn teplota pro 4.as
REF42	;15	;
 endc

EEADRp	EQU	0x7F	;pomocn EE adresa

Stisk	EQU	0	;FL,minule stisknuto
Znova	EQU	1	;FL,znova stisknuto
PS	EQU	2	;FL,porucha snmae
NM	EQU	3	;FL,neplatn men
Znam	EQU	4	;FL,znamnko 1=zporn teplota
ZEE	EQU	5	;FL,dost o zpis do EEPROM

DP	EQU	0	;FEE,doba platnosti ref.tep. 1=doasn, 0=trvale

UT	EQU	4	;KLVP,test napjen, 1=ZAP, 0=VYP
TlS	EQU	2	;KLVP,lev tlatko SET
TlM	EQU	1	;KLVP,prostedn tlatko MNUS
TlP	EQU	0	;KLVP,prav tlatko PLUS

Re	EQU	3	;vstup na PORTB

;*************************************************
 ORG	0x2100		;tabulka dat v EEPROM

 de 0x00, 0x10, 0xF0, 0x00, 0xFE, 0x05, 0x12, 0x1F
 de 0x36, 0x01, 0x12, 0x20, 0x40, 0x01, 0x12, 0x21
 de 0xE6, 0x00, 0x12, 0x22, 0xF0, 0x00, 0xFF, 0xFF
 de 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
 de 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
 de 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
 de 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
 de 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
 de 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
 de 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
 de 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
 de 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
 de 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
 de 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
 de 0x29, 0x53, 0x28, 0x31, 0x31, 0x2E, 0x32, 0x30
 de 0x30, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
;*************************************************

;reset
  	ORG	0
	GOTO	Init
	CALL	41
	CALL	83
	CALL	40
;================================
;peruen
	MOVWF	MemW
	MOVF	STATUS,W
	MOVWF	MemStat
;--------------------------------
	BTFSS	PIR1,TMR1IF	;od TMR1?
	GOTO	ITMR0		;NE

;peruen od peteen TMR1
	BCF	PIR1,TMR1IF	;VYP pznak
	BSF	FL,PS		;ZAP porucha snmae
	BCF	T1CON,TMR1ON	;stop asova TMR1
	CLRF	PV		;vynulovat poet vzork

	CLRW
	RETFIE
;--------------------------------
ITMR0	BTFSS	INTCON,T0IF	;od TMR0?
	GOTO	EINT		;NE

;peruen od asovae TMR0 (300Hz s krystalem 19.6608MHz)
	BCF	INTCON,T0IF	;VYP pznak
	BSF	FL,NM		;ZAP neplatn men
;dli 300/3=100Hz
	DECFSZ	De3,F		;-1=0?
	GOTO	$+12
	MOVLW	3		;znovu
	MOVWF	De3		; naplnit
;dli pro sekundu (100/100=1)
	DECFSZ	SEKD,F		;-1,=0?
	GOTO	$+4		;NE
	MOVLW	100		;znovu
	MOVWF	SEKD		; naplnit
	CALL	SEKUNDA
;dli pro blikn displeje
	INCF	BLIK,F		;+1
;dli pro opakovn KLV
	DECFSZ	KLVO,F		;-1=0?
	GOTO    $+2
	BSF	FL,Znova	;=1
;-------------------------------
;test napjen
	BTFSC	KLVP,UT		;zapnut napjen?
	GOTO	$+8		;ANO
;vypnut napjen, zhasnout displej
	MOVLW	0x20
	MOVWF	Znak0
	MOVWF	Znak1
	MOVWF	Znak3
;blikat, teka
	BTFSC	SEKD,6
	MOVLW	0xA0		;ZAP teku
	MOVWF	Znak2
;--------------------------------
;obsluha displeje a klvesnice
	MOVLW	Znak0		;adresa promnnch
  	MOVWF	FSR		; do FSR, kter slou jako ukazovtko (pointer)
	MOVF	Pozice,W
  	ADDWF	FSR,f		;pist aktuln pozici zobrazovanho znaku

  	MOVLW	B'00001000'	;zhasnout displej,
  	ANDWF	PORTB,F		; ostatn bity nemnit

;................................
;dli pro klvesnici (300/12=25)
	DECFSZ	KLVD,F		;-1=0?
	GOTO	$+16
	MOVLW	12		;znovu
	MOVWF	KLVD		; naplnit
;ten klvesnice
	BSF	STATUS,RP0	;Banka1
	MOVLW	B'00010111'
	MOVWF	TRISB		;1=vstup, 0=vstup
	BCF	STATUS,RP0	;Banka0
	MOVF	PORTB,W		;ten
	MOVF	PORTB,W		;ten
	MOVF	PORTB,W		;ten
	MOVF	PORTB,W		;ten
	ANDLW	B'00010111'	;(1a1=1)
	MOVWF	KLVP		;uloit
	BSF	STATUS,RP0	;Banka1
	CLRF	TRISB		;0=vstup
	BCF	STATUS,RP0	;Banka0
;................................

	MOVF	INDF,W		;nast znak z msta, na kter odkazuje FSR
	ANDLW	B'01111111'	;vynulovat bit7
	CALL	Znak		;pevede slo znaku na sedmisegmentov kd
	BTFSC	INDF,7		;nastaven teka?
	ANDLW	B'01111111'	;ANO, ZAP teku
	MOVWF	PORTA		;vyslat znak na PA
	ANDLW	B'11100000'	;
	IORWF	PORTB,F		;vyslat znak na PB
	CALL	Anoda		;vybrat anodu
	IORWF	PORTB,F		;zapnout anodu, ostatn bity nemnit

	INCF	Pozice,f	;zvtit pozici, dal znak
  	MOVLW	0x03		;celkem 4 msta (0-3)
	ANDWF	Pozice,f	;bity 7-4 odseknout
;--------------------------------
;zablokovat tlatka pi vypnutm napjen
	BTFSC	KLVP,UT		;zapnut napjen?
	GOTO	$+3		;ANO
	MOVLW	B'00000111'	;zablokovat tlatka
	MOVWF	KLVP		;
;--------------------------------
;konec peruen
EINT	MOVF	MemStat,W
	MOVWF	STATUS
	SWAPF	MemW,F
	SWAPF	MemW,W
	RETFIE
;================================
Anoda	MOVF	Pozice,W
  	ANDLW	0x03
  	ADDWF	PCL,F
  	RETLW	B'00000001'	;ZAP spol.anodu DIS.4 (Znak0)
  	RETLW	B'00000010'	;ZAP spol.anodu DIS.3 (Znak1)
  	RETLW	B'00000100'	;ZAP spol.anodu DIS.2 (Znak2)
  	RETLW	B'00010000'	;ZAP spol.anodu DIS.1 (Znak3)
;--------------------------------
Znak	MOVWF	PZnak
	SUBLW	0x26		;26-PZnak
	MOVF	PZnak,W		;pvodn znak
	BTFSS	STATUS,C	;kladn?
	MOVLW	0x13		;NE, nahradit znak
	ADDWF	PCL,F		;k PC se pite slo znaku
;		  Tbgedcaf	;Segment (0=svt)
	RETLW	B'10100000'	;0x00/0
	RETLW	B'10111011'	;0x01/1
	RETLW	B'10000101'	;0x02/2
	RETLW	B'10010001'	;0x03/3
	RETLW	B'10011010'	;0x04/4
	RETLW	B'11010000'	;0x05/5
	RETLW	B'11000000'	;0x06/6
	RETLW	B'10111001'	;0x07/7
	RETLW	B'10000000'	;0x08/8
	RETLW	B'10010000'	;0x09/9
	RETLW	B'10001000'	;0x0A/A
	RETLW	B'11000010'	;0x0B/b
	RETLW	B'11100100'	;0x0C/C
	RETLW	B'10000011'	;0x0D/d
	RETLW	B'11000100'	;0x0E/E
	RETLW	B'11001100'	;0x0F/F
	RETLW	B'10001010'	;0x10/H
	RETLW	B'11101111'	;0x11/i
	RETLW	B'10100011'	;0x12/J
	RETLW	B'11010101'	;0x13/ (3x -)
	RETLW	B'11100110'	;0x14/L
	RETLW	B'10101000'	;0x15/M
	RETLW	B'11001011'	;0x16/n
	RETLW	B'11000011'	;0x17/o
	RETLW	B'10001100'	;0x18/P
	RETLW	B'11001111'	;0x19/r
	RETLW	B'11011000'	;0x1A/S
	RETLW	B'11000110'	;0x1B/t
	RETLW	B'11100011'	;0x1C/u
	RETLW	B'10100010'	;0x1D/V
	RETLW	B'10010010'	;0x1E/Y
	RETLW	B'11011111'	;0x1F/-
	RETLW	B'11111111'	;0x20/ (zhasnuto)
	RETLW	B'11010111'	;0x21/=
	RETLW	B'10101010'	;0x22/II
	RETLW	B'11000111'	;0x23/c
	RETLW	B'10110001'	;0x24/)
	RETLW	B'10011011'	;0x25/-1
	RETLW	B'10011100'	;0x26/

;MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM
;men teploty
MT	MOVF	PV,F
	BTFSS	STATUS,Z	;PV=0?
	GOTO	$+7		;NE
	CLRF	SH1		;vynulovat SH
	CLRF	SH2		;
	CLRF	SH3		;
	CLRF	SP1		;vynulovat SP
	CLRF	SP2		;
	CLRF	SP3		;

	BCF	FL,PS		;VYP porucha snmae
	BCF	FL,NM		;VYP nov men
	CLRF	TMR1L		;vynulovat
	CLRF	TMR1H		; asova TMR1
	BSF	T1CON,TMR1ON	;start asova TMR1
;................................
;men signlu z SMT 160-30
;ekn na nulu
	MOVLW	3
	CLRWDT
	BTFSC	PORTA,5		;vstup=0?
	SUBWF	PCL,F		;dva kroky zpt

	BTFSC	FL,PS		;porucha snmae?
	GOTO	ES		;ANO
;ekn na jedniku
	CLRWDT
	BTFSS	PORTA,5		;vstup=1?
	SUBWF	PCL,F		;dva kroky zpt
;start men
	CLRF	TMR1L		;vynulovat
	CLRF	TMR1H		; asova TMR1

	BTFSC	FL,PS		;porucha snmae?
	GOTO	ES		;ANO
;ekn na nulu
	CLRWDT
	BTFSC	PORTA,5		;vstup=0?
	SUBWF	PCL,F		;dva kroky zpt
;uloit dlku rovn H
	MOVF	TMR1H,W
	MOVWF	A2
	MOVF	TMR1L,W
	MOVWF	A1
	MOVF	TMR1H,W
	XORWF	A2,W		;(st.=0),sZ=1
	BTFSC	STATUS,Z	;jin?
	GOTO	$+5		;NE
	MOVF	TMR1L,W
	MOVWF	A1
	MOVF	TMR1H,W
	MOVWF	A2

	BTFSC	FL,PS		;porucha snmae?
	GOTO	ES		;ANO
;ekn na jedniku
	MOVLW	3
	CLRWDT
	BTFSS	PORTA,5		;vstup=1?
	SUBWF	PCL,F		;dva kroky zpt
;uloit dlku periody, konec men
	BCF	T1CON,TMR1ON	;stop asova TMR1
	MOVF	TMR1L,W
	MOVWF	D1
	MOVF	TMR1H,W
	MOVWF	D2

	BTFSC	FL,PS		;porucha snmae?
	GOTO	ES		;ANO
;test neplatn men
	BTFSC	FL,NM		;neplatn men?
	GOTO	MT		;ANO, znova mit teplotu
;v A1,2 je dlka rovn H (H)
;v D1,2 je dlka periody  (P)
;     ______          _____
; ___|      |________|
;
;    |--H---|
;    |--------P------|
;................................
;souet vzork/256
;dlka H; (H1,2+SH3,1,2)/256=SH1,2
	MOVF	A1,W
	ADDWF	SH3,F		;A1+SH3=SH3
	BTFSC	STATUS,C	;nepeteklo?
	INCF	A2,F		;+1
	MOVF	A2,W
	ADDWF	SH1,F		;A2+SH1=SH1
	BTFSC	STATUS,C	;nepeteklo?
	INCF	SH2,F		;+1
;dlka P; (P1,2+SP3,1,2)/256=SP1,2
	MOVF	D1,W
	ADDWF	SP3,F		;D1+SP3=SP3
	BTFSC	STATUS,C	;nepeteklo?
	INCF	D2,F		;+1
	MOVF	D2,W
	ADDWF	SP1,F		;D2+SP1=SP1
	BTFSC	STATUS,C	;nepeteklo?
	INCF	SP2,F		;+1
;poet vzork +1
	INCFSZ	PV,F		;+1=0?
	RETURN			;NE, dal vzorky pt
;--------------------------------
;vpoet teploty
;v SH1,2 je prmrn dlka rovn H (H)
;v SP1,2 je prmrn dlka periody  (P)
;pprava
	MOVF	SH1,W		;SH1,2 do C1,2
	MOVWF	C1		;
	MOVF	SH2,W		;
	MOVWF	C2		;
	MOVF	SP1,W		;SP1,2 do B1,2
	MOVWF	B1		;
	MOVF	SP2,W		;
	MOVWF	B2		;
;vzorec H*2128/P-681 = A1,2 [C*10]
;H*2128=A
	CALL	x2128		;C1,2 * 2128 = A1,2,3
;A/P=C
	CLRF	B3
	CALL	LOMENO		;A1,2,3 / B1,2,3 = C1,2,3
;C-681=A
	MOVLW	0xA9		;681=0x02A9
	SUBWF	C1,W		;C1-A9
	MOVWF	A1		; =A1
	BTFSS	STATUS,C	;kladn?
	DECF	C2,F		;-1
	MOVLW	0x02
	SUBWF	C2,W		;C2-02
	MOVWF	A2		; =A2
;................................
;Diference, odstran chvn na nejnich bitech
	CALL	TB		;minul teplota T1,2 do B
;A1,2=nov teplota; B1,2=star; T1,2=vsledek
	CLRF	A3
	CALL	MINUS		;A-B=C
	MOVF	C2,F
	BTFSS	STATUS,Z	;C2=0?
	GOTO	$+17		;NE, nov < star

	MOVF	C1,W
	SUBLW	20		;20-C1
	BTFSS	STATUS,C	;kladn?
	GOTO	$+13		;NE, nov >= star+20

	MOVF	C1,W
	SUBLW	4		;4-C1
	BTFSC	STATUS,C	;zporn?
	GOTO	$+4		;NE, nov <= star+4

	INCFSZ	B1,F		;star teplota+1
	GOTO	$+2		;
	INCF	B2,F		;

	MOVF	B1,W		;star teplota B1,2 do T1,2
	MOVWF	T1		;
	MOVF	B2,W		;
	MOVWF	T2		;
	GOTO	PR

	MOVF	A1,W		;nov teplota A1,2 do T1,2
	MOVWF	T1		;
	MOVF	A2,W		;
	MOVWF	T2		;
	GOTO	PR
;-------------------------------;
;    Matematicke podprogramy	;
;-------------------------------;
;slovak@post.cz	      )S(03.2004;
;-------------------------------;
; A1,2,3 / B1,2,3 = C1,2,3
;24bit
;sZ=1=deleni nulou (B=0)
;B se nemeni, v A je zbytek
;pouziva D1,2,3; X1
LOMENO
;test B na nulu; sZ=1=ANO
;	MOVF	B1,F
;	BTFSC	STATUS,Z	;nenulove?
;	MOVF	B2,F
;	BTFSC	STATUS,Z	;nenulove?
;	MOVF	B3,F
;	BTFSC	STATUS,Z	;nenulove?
;	RETURN			;B=0
;priprava pro deleni
	MOVF	A1,W		;AdoD
	MOVWF	D1		;
	MOVF	A2,W		;
	MOVWF	D2		;
	MOVF	A3,W		;
	MOVWF	D3		;
	CLRF	A1		;nulovat
	CLRF	A2		;
	CLRF	A3		;
	MOVLW	24		;pocet bitu
	MOVWF	X1		;
	BCF	STATUS,C	;sC=0

LDalsi	CALL	x2M
	BTFSS	STATUS,C	;kladne?
	GOTO	LZapor
;LKlad				;jen pri sC=1
	MOVWF	A3		;CdoA
	MOVF	C2,W		;
	MOVWF	A2		;
	MOVF	C1,W		;
	MOVWF	A1		;

LZapor	DECFSZ	X1,F		;-1=0?
	GOTO	LDalsi
;vysledek
	RLF	D1,W		;posledni x2
	MOVWF	C1		; a WdoC
	RLF	D2,W		;
	MOVWF	C2		;
	RLF	D3,W		;
	MOVWF	C3		;
;konec
	BCF	STATUS,Z	;sZ=0
	RETURN
;--------------------------------
; D1,2,3 A1,2,3 * 2 a Minus
x2M	RLF	D1,F		;posuv vlevo
	RLF	D2,F		;
	RLF	D3,F		;
	RLF	A1,F		;
	RLF	A2,F		;
	RLF	A3,F		;
;--------------------------------
; A1,2,3 - B1,2,3 = C1,2,3
;sC=0=zaporny vysledek
;A,B se nemeni
MINUS	MOVF	B1,W		;W=B1
	SUBWF	A1,W		;A1-B1=W
	MOVWF	C1		;C1=W=vysledek1
	CLRW			;W=0
	BTFSS	STATUS,C	;SUB kladne?
	MOVLW	1		;W=1
	ADDWF	B2,W		;B2+W=W
	CLRF	C3		;C3=0
	BTFSC	STATUS,C	;ADD nepreteklo?
	BSF	C3,0		;C3=1
	SUBWF	A2,W		;A2-W=W
	MOVWF	C2		;C2=w=vysledek2
	MOVF	C3,W		;W=C3
	BTFSS	STATUS,C	;SUB kladne?
	MOVLW	1		;W=1
	ADDWF	B3,W		;B3+W=W
	CLRF	C3		;C3=0
	BTFSC	STATUS,C	;ADD nepreteklo?
	BSF	C3,0		;C3=1
	SUBWF	A3,W		;A3-W=W
	BTFSC	C3,0		;C3=0?
	BCF	STATUS,C	;sC=0
	MOVWF	C3		;C3=W=vysledek3
	RETURN
;::::::::::::::::::::::::::::::::
;test C=0; sZ=1=ANO
TC0	MOVF	C3,F
	BTFSC	STATUS,Z	;nenulove?
	MOVF	C2,F
	BTFSC	STATUS,Z	;nenulove?
	MOVF	C1,F
	RETURN
;--------------------------------
; C1,2 * 2128 = A1,2,3
x2128	CLRF	C3		
	CLRF	A1		;A=0
	CLRF	A2		;
	CLRF	A3		;
				;16+64+2048=2128
	MOVLW	4		;4x
	CALL	x2W		; posuv vlevo C =A
	MOVLW	2		;2x
	CALL	x2W		; posuv vlevo C =A
	MOVLW	5		;5x
	;CALL	x2W		; posuv vlevo C =A
	;RETURN

;C1,2,3 * 2^W = C1,2,3 + A1,2,3 = A1,2,3
x2W	MOVWF	X2		;kolikrt
	BCF	STATUS,C	;C=0
	RLF	C1,F		;posuv vlevo
	RLF	C2,F		;
	RLF	C3,F		;
	DECFSZ	X2,F		;-1=0?
	GOTO	$-5		;znova
	MOVF	C1,W
	ADDWF	A1,F		;C1+A1=A1
	BTFSS	STATUS,C	;peteklo?
	GOTO	$+4
	INCFSZ	A2,F		;+1=0?
	GOTO	$+2
	INCF	A3,F		;+1
	MOVF	C2,W
	ADDWF	A2,F		;C2+A2=A2
	BTFSC	STATUS,C	;nepeteklo?
	INCF	A3,F		;+1
	MOVF	C3,W
	ADDWF	A3,F		;C3+A3=A3
	RETURN
;--------------------------------
;X +1 (MAX 130.0)
XP1	MOVLW	0xFE
	SUBWF	X2,W		;X2-FE
	BTFSC	STATUS,C	;zporn?
	GOTO	$+14
	MOVLW	0x05
	SUBWF	X2,W		;X2-5
	BTFSS	STATUS,C	;kladn?
	GOTO	$+10
	MOVLW	0x14
	SUBWF	X1,W		;X1-14
	BTFSS	STATUS,C	;kladn?
	GOTO	$+6

	MOVLW	0x3E		;X=-450=FE3E
	MOVWF	X1		;
	MOVLW	0xFE		;
	MOVWF	X2		;
	RETURN

	INCFSZ	X1,F		;+1=0?
	RETURN
	INCF	X2,F		;+1
	RETURN
;--------------------------------
;X -1 (MIN -45.0)
XM1	;MOVF	X2,W
	SUBLW	0xFE		;FE-X2
	BTFSS	STATUS,Z	;nulov?
	GOTO	$+5
	MOVF	X1,W
	SUBLW	0x3E		;3E-X1
	BTFSC	STATUS,Z	;nenulov?
	GOTO	$+7

	MOVLW	1
	SUBWF	X1,F		;X1-1
	BTFSC	STATUS,C	;zporn?
	RETURN
	SUBWF	X2,F		;X2-1
	RETURN

	MOVLW	0x14		;X=1300=0514
	MOVWF	X1		;
	MOVLW	0x05		;
	MOVWF	X2		;
	RETURN
;================================
;pevod asu HEX/DEC; W/R1,R10 (d jedniky, destky)
CHD	MOVWF	R1		;
	CLRF	R10		;=0
CRad10	MOVLW	10		;vypocet radu desitek
	SUBWF	R1,W		;-10
	BTFSS	STATUS,C	;kladne?
	GOTO	CEnd10		;NE, hotovo
	MOVWF	R1		;ulozit rad jednicek
	INCF	R10,F		;+1
	GOTO	CRad10		;zpet
CEnd10	MOVF	R10,W		;rad desitek
	RETURN
;--------------------------------
;pevod HEX/DEC; A1,2/Znak0,1,2,3
HEXDEC
;upravit zporn slo
	BCF	FL,Znam		;=0
	BTFSS	A2,7		;=1?
	GOTO	$+7
	BSF	FL,Znam		;=1, zporn
	COMF	A2,F
	COMF	A1,F
	INCFSZ	A1,F		;+1=0?
	GOTO	$+2
	INCF	A2,F		;+1
;pprava pro pevod
	CLRF	A3
	CLRF	B3
	CLRF	D1
	CLRF	D2
	CLRF	D3
;pevod
Rad1000	MOVLW	0xE8
	MOVWF	B1
	MOVLW	0x03
	MOVWF	B2
	CALL	MINUS		;A1,2-1000=C1,2
	BTFSS	STATUS,C	;kladn?
	GOTO	Rad100		;NE
	MOVF	C1,W		;kladn zbytek
	MOVWF	A1		; po odetu
	MOVF	C2,W		; pesunout
	MOVWF	A2		; do A
	INCF	D3,F		;+1, zvtit d 1000
	GOTO	$-8
Rad100	MOVLW	100
	MOVWF	B1
	CLRF	B2
	CALL	MINUS		;A1,2-100=C1,2
	BTFSS	STATUS,C	;kladn?
	GOTO	Rad10		;NE
	MOVF	C1,W		;kladn zbytek
	MOVWF	A1		; po odetu
	MOVF	C2,W		; pesunout
	MOVWF	A2		; do A
	INCF	D2,F		;+1, zvtit d 100
	GOTO	$-8
Rad10	MOVLW	10
	SUBWF	A1,W		;A1-10=W
	BTFSS	STATUS,C	;kladn?
	GOTO	EPRE		;NE
	MOVWF	A1		;zbytek do A
	INCF	D1,F		;+1, zvtit d 10
	GOTO	Rad10
EPRE	MOVF	A1,W		;d 1
	MOVWF	Znak0		; zobrazit
	MOVF	D1,W		;d 10
	IORLW	B'10000000'	;zap desetinou teku	
	MOVWF	Znak1		; zobrazit
	MOVF	D2,W		;d 100
	MOVWF	Znak2		; zobrazit
	MOVF	D3,W		;d 1000
;nezobrazovat nulu
	BTFSC	STATUS,Z	;D3=0?
	MOVLW	0x20		;ANO, przdn znak
;znak pro zporn slo
	BTFSC	FL,Znam		;zporn teplota?
	MOVLW	0x1F		;ANO, znak -
	MOVWF	Znak3		; zobrazit
	RETURN
;================================
;test nco stisknuto?
TNS	CLRWDT
	MOVF	KLVP,W
	ANDLW	B'00000111'
	XORLW	B'00000111'	;(st.=0)
	BTFSS	STATUS,Z	;nic?
	GOTO	TNS		;nco
	RETURN
;--------------------------------
KLVM	CLRWDT
;pi vypnutm napjen uloit Hodiny do EEPROM
	BTFSC	KLVP,UT		;zapnut napjen?
	GOTO	$+36		;ANO
	CLRF	EEADRp		;adresa
	MOVF	Min,W		;data
	CALL	EWrite		;zpis
	INCF	EEADRp,F	;adresa+1
	MOVF	Hod,W		;data
	CALL	EWrite		;zpis
;po vpadku blikaj hodiny
	BTFSC	SEKD,6		;=0?
	GOTO	$+7
	MOVLW	0x20		;VYP displej
	MOVWF	Znak0		;
	MOVWF	Znak1		;
	MOVWF	Znak2		;
	MOVWF	Znak3		;
	GOTO	$+14

	MOVF	Hod,W		;hodiny
	CALL	CHD		;vrati R1,R10=W
	BTFSC	STATUS,Z	;C=0? nenulove
	MOVLW	0x20		;nezobrazovat nulu
	MOVWF	Znak3		;Hod desitky
	MOVF	R1,W		;rad jednicek
	IORLW	B'10000000'	;zap. teku
	MOVWF	Znak2		;Hod jednicky
	MOVF	Min,W		;minuty
	CALL	CHD
	MOVWF	Znak1		;Min desitky
	MOVF	R1,W		;rad jednicek
	MOVWF	Znak0		;Min jednicky

	CLRWDT
	BTFSC	KLVP,UT		;vypnut napjen?
	CALL	MT

	MOVF	KLVP,W
	ANDLW	B'00000111'
	XORLW	B'00000111'
	BTFSC	STATUS,Z	;=0?, neco stisknuto?
	GOTO	$-28		;NE

;men teploty
	CALL	MT
;test KLV + opakovan, sZ=0=nco stisknuto, 1=dn tlatko
KLV	CLRWDT
	MOVF	KLVP,W
	ANDLW	B'00000111'
	XORLW	B'00000111'	;(st.=0)
	BTFSS	STATUS,Z	;=1?, nenulov? (dn tlatko)
	GOTO	Neco		;nco stisknuto
	BCF	FL,Stisk	;=0
	BSF	FL,Znova	;=1
	RETURN
Neco	BTFSC	KLVP,TlS	;stisknuto TlS?
	CLRF	BLIK		;NE, nulovat
	BSF	STATUS,Z	;=1
	BTFSS	FL,Znova	;=1? odasovno?
	RETURN			;NE, jako dn tl.
	MOVLW	10		;krat as (0.1s)
	BTFSS	FL,Stisk	;minule stisknuto?
	MOVLW	100		;del as (1s)
	MOVWF	KLVO		;nastavit asova pro opakovn
	BTFSS	KLVP,TlS	;stisknuto TlS?
	CLRF	KLVO		;ANO, MAX as (2.5s)
	BCF	FL,Znova	;=0
	BSF	FL,Stisk	;=1
	BCF	STATUS,Z	;=0
	RETURN
;================================
;ten EEPROM, adresu do EEADRp, vrt data v W
ERead	BSF	STATUS,RP0	;Banka1
	MOVF	EEADRp,W
	MOVWF	EEADR		;adresa
	BSF	EECON1,RD	;ten
	MOVF	EEDATA,W
	BCF	STATUS,RP0	;Banka0
	RETURN
;--------------------------------
;zpis do EEPROM, adresu do EEADRp, data do W
EWrite	CLRWDT
	BCF	INTCON,GIE	;zakzat peruen
	BSF	STATUS,RP0	;Banka1
	MOVWF	EEDATA		;data
	MOVF	EEADRp,W
	MOVWF	EEADR		;adresa
	BSF	EECON1,WREN	;zpis povolen
	MOVLW	0x55		;vodn
	MOVWF	EECON2		; sekvence
	MOVLW	0xAA		;
	MOVWF	EECON2		;
	BSF	EECON1,WR	;zpis
EEIF0	BTFSC	EECON1,WR	;konec zpisu?
	GOTO	EEIF0		;NE
	BCF	EECON1,WREN	;zpis zkzn
	BCF	STATUS,RP0	;Banka0
;pauza po zpisu
	CLRW
	ADDLW	1		;W+1
	BTFSS	STATUS,Z	;W=0?
	GOTO	$-2		;NE

	BSF	INTCON,GIE	;povolit peruen
	RETURN
;================================
SEKUNDA
;	BTFSS	PORTB,3
;	GOTO	$+3
;	BCF	PORTB,3
;	GOTO	$+2
;	BSF	PORTB,3

;sekundy+1
	INCF	Sek,F		;+1
	MOVF	Sek,W
	SUBLW	59		;59-Sek
	BTFSC	STATUS,C	;C=0? zporn?
	RETURN			;NE
	CLRF	Sek		;=0
;minuty+1
	INCF	Min,F		;+1
	MOVF	Min,W
	SUBLW	59		;59-Min
	BTFSC	STATUS,C	;C=0? zporn?
	GOTO	KC		;NE
	CLRF	Min		;=0
;hodiny+1
	INCF	Hod,F		;+1
	MOVF	Hod,W
	SUBLW	23		;23-Hod
	BTFSS	STATUS,C	;C=1? kladn?
	CLRF	Hod		;ANO;=0
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;kontrola as
KC
;kontrola platnosti ref.teploty (1=doasn, 0=trval)
	BTFSS	FEE,DP		;=1?
	RETURN
;................................
	BCF	FL,ZEE		;VYP dost o zpis do EEPROM
;1.as
	MOVF	Min,W		;minuty
	XORWF	CAS1M,W		;
	BTFSS	STATUS,Z	;jsou stejn?
	GOTO	KC2		;NE
	MOVF	Hod,W		;hodiny
	XORWF	CAS1H,W		;
	BTFSS	STATUS,Z	;jsou stejn?
	GOTO	KC2		;NE
;1.as=hodiny, zmna ref.teploty
	MOVF	REF11,W		;REF1
	MOVWF	RT1		; do RT
	MOVF	REF12,W		;
	MOVWF	RT2		;
	BSF	FL,ZEE		;ZAP dost
;2.as
KC2	MOVF	Min,W
	XORWF	CAS2M,W
	BTFSS	STATUS,Z	;stejn?
	GOTO	KC3		;NE
	MOVF	Hod,W
	XORWF	CAS2H,W
	BTFSS	STATUS,Z	;stejn?
	GOTO	KC3		;NE
;2.as=hodiny, zmna ref.teploty
	MOVF	REF21,W		;REF2
	MOVWF	RT1		; do RT
	MOVF	REF22,W		;
	MOVWF	RT2		;
	BSF	FL,ZEE		;ZAP dost
;3.as
KC3	MOVF	Min,W
	XORWF	CAS3M,W
	BTFSS	STATUS,Z	;stejn?
	GOTO	KC4		;NE
	MOVF	Hod,W
	XORWF	CAS3H,W
	BTFSS	STATUS,Z	;stejn?
	GOTO	KC4		;NE
;3.as=hodiny, zmna ref.teploty
	MOVF	REF31,W		;REF3
	MOVWF	RT1		; do RT
	MOVF	REF32,W		;
	MOVWF	RT2		;
	BSF	FL,ZEE		;ZAP dost
;4.as
KC4	MOVF	Min,W
	XORWF	CAS4M,W
	BTFSS	STATUS,Z	;stejn?
	RETURN			;NE
	MOVF	Hod,W
	XORWF	CAS4H,W
	BTFSS	STATUS,Z	;stejn?
	GOTO	KZEE		;NE
;4.as=hodiny, zmna ref.teploty
	MOVF	REF41,W		;REF4
	MOVWF	RT1		; do RT
	MOVF	REF42,W		;
	MOVWF	RT2		;
	GOTO	ZRTEE		;zapsat
;kontrola dosti o zpis do EEPROM
KZEE	BTFSS	FL,ZEE		;zapnuto?
	RETURN			;NE
;zpis ref.teploty do EEPROM
ZRTEE	MOVLW	0x02		;adresa
	MOVWF	EEADRp		;
	MOVF	RT1,W		;data
	CALL	EWrite		;zpis
	INCF	EEADRp,F	;adresa+1
	MOVF	RT2,W		;data
	CALL	EWrite		;zpis
	RETURN

;IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII
;iniciace
Init	MOVLW   0x07		;OFF
	MOVWF	CMCON		; Comparators

;obnoven RAM z EEPROM 0x00-0x15
	CLRF	EEADRp		;poten adresa EEPROM
	MOVLW	Min		;poten adresa RAM
	MOVWF	FSR
	GOTO	$+2

	INCF	FSR,F		;+1
	CALL	ERead
	MOVWF	INDF
	INCF	EEADRp,F	;+1
	MOVF	EEADRp,W
	SUBLW	0x15		;posledn adresa EEPROM
	BTFSC	STATUS,C	;zporn?
	GOTO	$-7		;NE

;zkladn nasteven
	BSF	STATUS,RP0	;Banka1
	MOVLW	B'00100000'	;PORTA vstup mimo A5
	MOVWF	TRISA		;
	CLRF	TRISB		;PORTB vstup
	MOVLW	B'01000101'	;peddli 1:64 pro TMR0
	MOVWF	OPTION_REG	;
	MOVLW	B'00000001'	;peruen od TMR1
	MOVWF	PIE1		;
	BCF	STATUS,RP0	;Banka0
	MOVLW	B'11100000'	;peruen od TMR0
	MOVWF	INTCON		;
	MOVLW	B'00000101'	;peddli 1:1 pro TMR1
	MOVWF	T1CON		;
	CLRF	Pozice		;vynulovat
	CLRF	FL		;
	CLRF	PV		;
	CLRF	KLVD		;
	MOVLW	B'00000111'	;UT=0
	MOVWF	KLVP		;

;********************************
;nadpis [  C] teplota
NT	MOVLW	0x20		;
	MOVWF	Znak3
	MOVWF	Znak2
	MOVLW	0x26		;
	MOVWF	Znak1
	MOVLW	0x0C		;C
	MOVWF	Znak0
	CALL	TNS		;test neco stisknuto?
;zobrazit teplotu
ZT	BTFSS	FL,PS		;porucha snmae?
	GOTO	$+7		;NE
	MOVLW	0x1F		;zobrazit [----]
	MOVWF	Znak0		;
	MOVWF	Znak1		;
	MOVWF	Znak2		;
	MOVWF	Znak3		;
	GOTO	$+6

	MOVF	T1,W
	MOVWF	A1
	MOVF	T2,W
	MOVWF	A2
	CALL	HEXDEC

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto
	GOTO	ZT		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	NT		;ANO
	BTFSS	KLVP,TlM	;stisknuto?
	GOTO	NRUP		;ANO, na konec
;--------------------------------
;nadpis [Hod. ] Hodiny
NHOD	MOVLW	0x10		;H
	MOVWF	Znak3
	MOVLW	0x17		;o
	MOVWF	Znak2
	MOVLW	0x8D		;d.
	MOVWF	Znak1
	MOVLW	0x20
	MOVWF	Znak0
	CALL	TNS		;test neco stisknuto?
;zobrazit Hod
ZHOD	MOVF	Hod,W		;hodiny
	CALL	CHD		;vrati R1,R10=W
	BTFSC	STATUS,Z	;C=0? nenulove
	MOVLW	0x20		;nezobrazovat nulu
	MOVWF	Znak3		;Hod desitky
;blikat, desetin teka
	MOVF	SEKD,W
	ANDLW	B'01100000'
	BTFSC	STATUS,Z	;=1?
	BCF	R1,7		;zap tecku
	BTFSS	STATUS,Z	;=0?
	BSF	R1,7		;vyp tecku
	MOVF	R1,W		;rad jednicek
	MOVWF	Znak2		;Hod jednicky
;zobrazit Min
	MOVF	Min,W		;minuty
	CALL	CHD
	MOVWF	Znak1		;Min desitky
	MOVF	R1,W		;rad jednicek
	MOVWF	Znak0		;Min jednicky

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto
	GOTO	ZHOD		;NE
	BTFSS	KLVP,TlM	;stisknuto?
	GOTO	NT		;ANO, minul
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	NREFT		;ANO, dal

	MOVLW	0x10		;H
	MOVWF	Znak3
	MOVLW	0x17		;o
	MOVWF	Znak2
	MOVLW	0x8D		;d.
	MOVWF	Znak1
	MOVLW	0x20
	MOVWF	Znak0
;pauza pro S
	CLRWDT
	BTFSC	KLVP,TlS	;stisknuto?
	GOTO	ZHOD		;NE
	BTFSS	FL,Znova	;odcasovano?
	GOTO	$-4		;NE
	BCF	FL,Znova	;nulovat
;................................
;Vloit HOD
EHOD
;blikat, Hod
	BTFSS	BLIK,4
	GOTO	$+6
	MOVLW	0x20		;VYP
	MOVWF	Znak3		; displej
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2		;
	GOTO	$+7
	MOVF	Hod,W		;hodiny
	CALL	CHD		;vrati R1,R10=W
	MOVWF	Znak3		;Hod desitky
	MOVF	R1,W		;rad jednicek
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2		;Hod jednicky
;zobrazit Min
	MOVF	Min,W		;minuty
	CALL	CHD
	MOVWF	Znak1		;Min desitky
	MOVF	R1,W		;rad jednicek
	MOVWF	Znak0		;Min jednicky

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	EHOD		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	EMIN		;ANO
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	PHOD		;ANO
;Hod -1
	MOVLW	1
	SUBWF	Hod,F		;Hod-1
	BTFSC	STATUS,C	;zporn?
	GOTO	EHOD		;NE
	MOVLW	23
	MOVWF	Hod
	GOTO	EHOD
;Hod +1
PHOD	INCF	Hod,F		;Hod+1
	MOVF	Hod,W
	SUBLW	23		;23-Hod
	BTFSS	STATUS,C	;C=1? kladne
	CLRF	Hod		;NE;=0
	GOTO	EHOD
;................................
;vloit MIN
EMIN
;zobrazit Hod
	MOVF	Hod,W		;hodiny
	CALL	CHD		;vrati R1,R10=W
	MOVWF	Znak3		;Hod desitky
	MOVF	R1,W		;rad jednicek
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2		;Hod jednicky
;blikat, Min
	BTFSS	BLIK,4
	GOTO	$+5
	MOVLW	0x20		;VYP
	MOVWF	Znak1		; displej
	MOVWF	Znak0		;
	GOTO	$+6
	MOVF	Min,W		;minuty
	CALL	CHD
	MOVWF	Znak1		;Min desitky
	MOVF	R1,W		;rad jednicek
	MOVWF	Znak0		;Min jednicky

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	EMIN		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	ESEK		;ANO
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	PMIN		;ANO
;Min -1
	MOVLW	1
	SUBWF	Min,F		;Min-1
	BTFSC	STATUS,C	;zporn?
	GOTO	EMIN		;NE
	MOVLW	59
	MOVWF	Min
	GOTO	EMIN
;Min +1
PMIN	INCF	Min,F		;Min+1
	MOVF	Min,W
	SUBLW	59		;59-Min
	BTFSS	STATUS,C	;C=1? kladne
	CLRF	Min		;NE;=0
	GOTO	EMIN
;................................
;vloit SEK
ESEK	MOVLW	0x05		;S
	MOVWF	Znak3
	MOVLW	0x8E		;E.
	MOVWF	Znak2
	MOVF	Sek,W		;sekundy
	CALL	CHD
	MOVWF	Znak1		;Sek desitky
	MOVF	R1,W		;rad jednicek
	MOVWF	Znak0		;Sek jednicky

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	ESEK		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	NHOD		;ANO
;nulovat sekundy
	CLRF	Sek
	MOVLW	100		;znovu
	MOVWF	SEKD		; naplnit
	GOTO	ESEK
;--------------------------------
;nadpis [rEF.t.] referenn teplota
NREFT	MOVLW	0x19		;r
	MOVWF	Znak3
	MOVLW	0x0E		;E
	MOVWF	Znak2
	MOVLW	0x8F		;F.
	MOVWF	Znak1
	MOVLW	0x9B		;t.
	MOVWF	Znak0
	CALL	TNS		;test neco stisknuto?
;zobrazit RT
ZRT	MOVF	RT1,W
	MOVWF	A1
	MOVF	RT2,W
	MOVWF	A2
	CALL	HEXDEC
;zobrazit teku (vyp=trval / zap=doasn ref.teplota)
	BTFSS	SEKD,6
	GOTO	$+3
	BTFSC	FEE,DP		;=0?
	BSF	Znak0,7		;ZAP teku

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto
	GOTO	ZRT		;NE
	BTFSS	KLVP,TlM	;stisknuto?
	GOTO	NHOD		;ANO, minul
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	NHYST		;ANO, dal

	MOVLW	0x19		;r
	MOVWF	Znak3
	MOVLW	0x0E		;E
	MOVWF	Znak2
	MOVLW	0x8F		;F.
	MOVWF	Znak1
	MOVLW	0x9B		;t.
	MOVWF	Znak0
;pauza pro S
	CLRWDT
	BTFSC	KLVP,TlS	;stisknuto?
	GOTO	ZRT		;NE
	BTFSS	FL,Znova	;odcasovano?
	GOTO	$-4		;NE
	BCF	FL,Znova	;nulovat
;Vloit REFT
EREFT
;blikat, RT
	BTFSS	BLIK,4
	GOTO	$+7
	MOVLW	0x20		;VYP
	MOVWF	Znak3		; displej
	MOVWF	Znak2		;
	MOVWF	Znak1		;
	MOVWF	Znak0		;
	GOTO	$+6
	MOVF	RT1,W		;referenn teplota
	MOVWF	A1		;
	MOVF	RT2,W		;
	MOVWF	A2		;
	CALL	HEXDEC

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	EREFT		;NE
	BTFSC	KLVP,TlS	;stisknuto?
	GOTO	$+3		;NE
	CALL	ZRTEE		;zapsat RT do EEPROM
	GOTO	NDTRT		;NREFT
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	PRT		;ANO
;RT -1
	MOVF	RT1,W
	MOVWF	X1
	MOVF	RT2,W
	MOVWF	X2
	CALL	XM1
	MOVF	X1,W
	MOVWF	RT1
	MOVF	X2,W
	MOVWF	RT2
	GOTO	EREFT
;RT +1
PRT	MOVF	RT1,W
	MOVWF	X1
	MOVF	RT2,W
	MOVWF	X2
	CALL	XP1
	MOVF	X1,W
	MOVWF	RT1
	MOVF	X2,W
	MOVWF	RT2
	GOTO	EREFT
;................................
;nadpis [doc. ] / [trv. ] doasnn/trval ref.teplota
NDTRT
;blikat DT
	BTFSS	BLIK,4
	GOTO	$+7
	MOVLW	0x20		;VYP
	MOVWF	Znak3		; displej
	MOVWF	Znak2		;
	MOVWF	Znak1
	MOVWF	Znak0
	GOTO	$+18

	BTFSS	FEE,DP		;=1?
	GOTO	$+10
	MOVLW	0x0D		;d
	MOVWF	Znak3
	MOVLW	0x17		;o
	MOVWF	Znak2
	MOVLW	0xA3		;c.
	MOVWF	Znak1
	MOVLW	0xA0		;.
	MOVWF	Znak0
	GOTO	$+7

	MOVLW	0x1B		;t
	MOVWF	Znak3
	MOVLW	0x19		;r
	MOVWF	Znak2
	MOVLW	0x9C		;v.
	MOVWF	Znak1

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	NDTRT		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	ZDT		;ANO
;zmba DT
	BTFSS	FEE,DP		;=1?
	GOTO	$+3
	BCF	FEE,DP		;=0
	GOTO	NDTRT
	BSF	FEE,DP		;=1
	GOTO	NDTRT
;zpis DP
ZDT	MOVLW	0x04		;adresa
	MOVWF	EEADRp
	MOVF	FEE,W		;data
	CALL	EWrite		;zpis
	GOTO	NREFT
;--------------------------------
;nadpis [HYSt.] hystereze
NHYST	MOVLW	0x10		;H
	MOVWF	Znak3
	MOVLW	0x1E		;Y
	MOVWF	Znak2
	MOVLW	0x05		;S
	MOVWF	Znak1
	MOVLW	0x9B		;t.
	MOVWF	Znak0
	CALL	TNS		;test neco stisknuto?
;zobrazit HYST
ZHYST	MOVF	HYST,W		;hystereze
	MOVWF	A1
	CLRF	A2
	CALL	HEXDEC

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto
	GOTO	ZHYST		;NE
	BTFSS	KLVP,TlM	;stisknuto?
	GOTO	NREFT		;ANO, minul
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	NCAS1		;ANO, dal

	MOVLW	0x10		;H
	MOVWF	Znak3
	MOVLW	0x1E		;Y
	MOVWF	Znak2
	MOVLW	0x05		;S
	MOVWF	Znak1
	MOVLW	0x9B		;t.
	MOVWF	Znak0
;pauza pro S
	CLRWDT
	BTFSC	KLVP,TlS	;stisknuto?
	GOTO	ZHYST		;NE
	BTFSS	FL,Znova	;odcasovano?
	GOTO	$-4		;NE
	BCF	FL,Znova	;nulovat
;vloit HYST
EHYST
;blikat HYST
	BTFSS	BLIK,4
	GOTO	$+7
	MOVLW	0x20		;VYP
	MOVWF	Znak3		; displej
	MOVWF	Znak2		;
	MOVWF	Znak1		;
	MOVWF	Znak0		;
	GOTO	$+5
	MOVF	HYST,W		;hystereze
	MOVWF	A1		;
	CLRF	A2
	CALL	HEXDEC

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	EHYST		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	ZHYEE		;ANO
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	PHY		;ANO
;HYST -1
	DECF	HYST,F		;+1
	GOTO	EHYST
;HYST +1
PHY	INCF	HYST,F		;-1
	GOTO	EHYST
;zpis HYST do EEPROM
ZHYEE	MOVLW	0x05		;adresa
	MOVWF	EEADRp		;
	MOVF	HYST,W		;data
	CALL	EWrite		;zpis
	GOTO	NHYST
;--------------------------------
;nadpis [1.CAS] 1.as pro zmnu ref. teploty
NCAS1	MOVLW	0x81		;1.
	MOVWF	Znak3
	MOVLW	0x0C		;C
	MOVWF	Znak2
	MOVLW	0x0A		;A
	MOVWF	Znak1
	MOVLW	0x05		;S
	MOVWF	Znak0
	CALL	TNS		;test neco stisknuto?
;zobrazit CAS1H
ZC1	MOVF	CAS1H,W		;as 1 hodiny
	CALL	CHD
	BTFSC	STATUS,Z	;C=0? nenulove
	MOVLW	0x20		;nezobrazovat nulu
	MOVWF	Znak3
	MOVF	R1,W
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2
;zobrazit CAS1M
	MOVF	CAS1M,W		;as 1 minuty
	CALL	CHD
	MOVWF	Znak1
	MOVF	R1,W
	MOVWF	Znak0

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto
	GOTO	ZC1		;NE
	BTFSS	KLVP,TlM	;stisknuto?
	GOTO	NHYST		;ANO, minul
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	NREF1		;ANO, dal

	MOVLW	0x81		;1.
	MOVWF	Znak3
	MOVLW	0x0C		;C
	MOVWF	Znak2
	MOVLW	0x0A		;A
	MOVWF	Znak1
	MOVLW	0x05		;S
	MOVWF	Znak0
;pauza pro S
	CLRWDT
	BTFSC	KLVP,TlS	;stisknuto?
	GOTO	ZC1		;NE
	BTFSS	FL,Znova	;odcasovano?
	GOTO	$-4		;NE
	BCF	FL,Znova	;nulovat
;vloit CAS1H
EC1H
;blikat CAS1H
	BTFSS	BLIK,4
	GOTO	$+6
	MOVLW	0x20		;VYP
	MOVWF	Znak3		; displej
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2		;
	GOTO	$+7
	MOVF	CAS1H,W		;as 1 Hod
	CALL	CHD		;vrati R1,R10=W
	MOVWF	Znak3		;Hod 1 desitky
	MOVF	R1,W		;rad jednicek
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2		;Hod 1 jednicky
;zobrazit CAS1M
	MOVF	CAS1M,W		;as 1 Min
	CALL	CHD
	MOVWF	Znak1		;Min 1 desitky
	MOVF	R1,W		;rad jednicek
	MOVWF	Znak0		;Min 1 jednicky

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	EC1H		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	EC1M		;ANO
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	PC1H		;ANO
;as 1 Hod -1
	MOVLW	1
	SUBWF	CAS1H,F		;as 1 Hod-1
	BTFSC	STATUS,C	;zporn?
	GOTO	EC1H		;NE
	MOVLW	23
	MOVWF	CAS1H
	GOTO	EC1H
;as 1 Hod +1
PC1H	INCF	CAS1H,F		;as 1 Hod+1
	MOVF	CAS1H,W
	SUBLW	23		;23-CAS1H
	BTFSS	STATUS,C	;C=1? kladne
	CLRF	CAS1H		;NE;=0
	GOTO	EC1H
;vloit CAS1M
EC1M
;zobrazit CAS1H
	MOVF	CAS1H,W		;as 1 Hod
	CALL	CHD		;vrati R1,R10=W
	MOVWF	Znak3		;Hod 1 desitky
	MOVF	R1,W		;rad jednicek
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2		;Hod 1 jednicky
;blikat CAS1M
	BTFSS	BLIK,4
	GOTO	$+5
	MOVLW	0x20		;VYP
	MOVWF	Znak1		; displej
	MOVWF	Znak0		;
	GOTO	$+6
	MOVF	CAS1M,W		;as 1 Min
	CALL	CHD
	MOVWF	Znak1		;Min 1 desitky
	MOVF	R1,W		;rad jednicek
	MOVWF	Znak0		;Min 1 jednicky

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	EC1M		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	Z1CEE		;ANO
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	PC1M		;ANO
;as 1 Min -1
	MOVLW	1
	SUBWF	CAS1M,F		;as 1 Min-1
	BTFSC	STATUS,C	;zporn?
	GOTO	EC1M		;NE
	MOVLW	59
	MOVWF	CAS1M
	GOTO	EC1M
;as 1 Min +1
PC1M	INCF	CAS1M,F		;as 1 Min+1
	MOVF	CAS1M,W
	SUBLW	59		;23-CAS1M
	BTFSS	STATUS,C	;C=1? kladne
	CLRF	CAS1M		;NE;=0
	GOTO	EC1M
;zpis 1.as do EEPROM
Z1CEE	MOVLW	0x06		;adresa
	MOVWF	EEADRp		;
	MOVF	CAS1H,W		;data
	CALL	EWrite		;zpis
	INCF	EEADRp,F	;adresa+1
	MOVF	CAS1M,W		;data
	CALL	EWrite		;zpis
	GOTO	NCAS1
;--------------------------------
;nadpis [1.rEF.] 1.referenn teplota pro 1.as
NREF1	MOVLW	0x81		;1.
	MOVWF	Znak3
	MOVLW	0x19		;r
	MOVWF	Znak2
	MOVLW	0x0E		;E
	MOVWF	Znak1
	MOVLW	0x8F		;F.
	MOVWF	Znak0
	CALL	TNS		;test neco stisknuto?
;zobrazit REF1
ZREF1	MOVF	REF11,W		;referenn teplota pro as 1
	MOVWF	A1
	MOVF	REF12,W
	MOVWF	A2
	CALL	HEXDEC

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto
	GOTO	ZREF1		;NE
	BTFSS	KLVP,TlM	;stisknuto?
	GOTO	NCAS1		;ANO, minul
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	NCAS2		;ANO, dal

	MOVLW	0x81		;1.
	MOVWF	Znak3
	MOVLW	0x19		;r
	MOVWF	Znak2
	MOVLW	0x0E		;E
	MOVWF	Znak1
	MOVLW	0x8F		;F.
	MOVWF	Znak0
;pauza pro S
	CLRWDT
	BTFSC	KLVP,TlS	;stisknuto?
	GOTO	ZREF1		;NE
	BTFSS	FL,Znova	;odcasovano?
	GOTO	$-4		;NE
	BCF	FL,Znova	;nulovat
;vloit R1
EREF1
;blikat R1
	BTFSS	BLIK,4
	GOTO	$+7
	MOVLW	0x20		;VYP
	MOVWF	Znak3		; displej
	MOVWF	Znak2		;
	MOVWF	Znak1		;
	MOVWF	Znak0		;
	GOTO	$+6
	MOVF	REF11,W		;ref.teplota pro as 1
	MOVWF	A1		;
	MOVF	REF12,W		;
	MOVWF	A2		;
	CALL	HEXDEC

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	EREF1		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	Z1REE		;ANO
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	PREF1		;ANO
;REF1 -1
	MOVF	REF11,W
	MOVWF	X1
	MOVF	REF12,W
	MOVWF	X2
	CALL	XM1
	MOVF	X1,W
	MOVWF	REF11
	MOVF	X2,W
	MOVWF	REF12
	GOTO	EREF1
;R1 +1
PREF1	MOVF	REF11,W
	MOVWF	X1
	MOVF	REF12,W
	MOVWF	X2
	CALL	XP1
	MOVF	X1,W
	MOVWF	REF11
	MOVF	X2,W
	MOVWF	REF12
	GOTO	EREF1
;zpis 1.REF do EEPROM
Z1REE	MOVLW	0x08		;adresa
	MOVWF	EEADRp		;
	MOVF	REF11,W		;data
	CALL	EWrite		;zpis
	INCF	EEADRp,F	;adresa+1
	MOVF	REF12,W		;data
	CALL	EWrite		;zpis
	GOTO	NREF1
;--------------------------------
;nadpis [2.CAS] 2.as pro zmnu ref. teploty
NCAS2	MOVLW	0x82		;2.
	MOVWF	Znak3
	MOVLW	0x0C		;C
	MOVWF	Znak2
	MOVLW	0x0A		;A
	MOVWF	Znak1
	MOVLW	0x05		;S
	MOVWF	Znak0
	CALL	TNS		;test neco stisknuto?
;zobrazit CAS2H
ZC2	MOVF	CAS2H,W		;as 2 hodiny
	CALL	CHD
	BTFSC	STATUS,Z	;C=0? nenulove
	MOVLW	0x20		;nezobrazovat nulu
	MOVWF	Znak3
	MOVF	R1,W
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2
;zobrazit CAS2M
	MOVF	CAS2M,W		;as 2 minuty
	CALL	CHD
	MOVWF	Znak1
	MOVF	R1,W
	MOVWF	Znak0

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto
	GOTO	ZC2		;NE
	BTFSS	KLVP,TlM	;stisknuto?
	GOTO	NREF1		;ANO, minul
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	NREF2		;ANO, dal

	MOVLW	0x82		;2.
	MOVWF	Znak3
	MOVLW	0x0C		;C
	MOVWF	Znak2
	MOVLW	0x0A		;A
	MOVWF	Znak1
	MOVLW	0x05		;S
	MOVWF	Znak0
;pauza pro S
	CLRWDT
	BTFSC	KLVP,TlS	;stisknuto?
	GOTO	ZC2		;NE
	BTFSS	FL,Znova	;odcasovano?
	GOTO	$-4		;NE
	BCF	FL,Znova	;nulovat
;vloit CAS2H
ECAS2H
;blikat CAS2H
	BTFSS	BLIK,4
	GOTO	$+6
	MOVLW	0x20		;VYP
	MOVWF	Znak3		; displej
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2		;
	GOTO	$+7
	MOVF	CAS2H,W		;as 2 Hod
	CALL	CHD		;vrati R1,R10=W
	MOVWF	Znak3		;Hod 2 desitky
	MOVF	R1,W		;rad jednicek
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2		;Hod 2 jednicky
;zobrazit CAS2M
	MOVF	CAS2M,W		;as 2 Min
	CALL	CHD
	MOVWF	Znak1		;Min 2 desitky
	MOVF	R1,W		;rad jednicek
	MOVWF	Znak0		;Min 2 jednicky

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	ECAS2H		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	ECAS2M		;ANO
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	PCAS2H		;ANO
;as 2 Hod -1
	MOVLW	1
	SUBWF	CAS2H,F		;as 2 Hod-1
	BTFSC	STATUS,C	;zporn?
	GOTO	ECAS2H		;NE
	MOVLW	23
	MOVWF	CAS2H
	GOTO	ECAS2H
;as 2 Hod +1
PCAS2H	INCF	CAS2H,F		;as 2 Hod+1
	MOVF	CAS2H,W
	SUBLW	23		;23-CAS1H
	BTFSS	STATUS,C	;C=1? kladne
	CLRF	CAS2H		;NE;=0
	GOTO	ECAS2H
;vloit CAS2M
ECAS2M
;zobrazit CAS2H
	MOVF	CAS2H,W		;as 2 Hod
	CALL	CHD		;vrati R1,R10=W
	MOVWF	Znak3		;Hod 2 desitky
	MOVF	R1,W		;rad jednicek
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2		;Hod 2 jednicky
;blikat CAS2M
	BTFSS	BLIK,4
	GOTO	$+5
	MOVLW	0x20		;VYP
	MOVWF	Znak1		; displej
	MOVWF	Znak0		;
	GOTO	$+6
	MOVF	CAS2M,W		;as 2 Min
	CALL	CHD
	MOVWF	Znak1		;Min 2 desitky
	MOVF	R1,W		;rad jednicek
	MOVWF	Znak0		;Min 2 jednicky

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	ECAS2M		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	Z2CEE		;ANO
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	PCAS2M		;ANO
;as 2 Min -1
	MOVLW	1
	SUBWF	CAS2M,F		;as 2 Min-1
	BTFSC	STATUS,C	;zporn?
	GOTO	ECAS2M		;NE
	MOVLW	59
	MOVWF	CAS2M
	GOTO	ECAS2M
;as 2 Min +1
PCAS2M	INCF	CAS2M,F		;as 2 Min+1
	MOVF	CAS2M,W
	SUBLW	59		;23-CAS2M
	BTFSS	STATUS,C	;C=1? kladne
	CLRF	CAS2M		;NE;=0
	GOTO	ECAS2M
;zpis 2.as do EEPROM
Z2CEE	MOVLW	0x0A		;adresa
	MOVWF	EEADRp		;
	MOVF	CAS2H,W		;data
	CALL	EWrite		;zpis
	INCF	EEADRp,F	;adresa+1
	MOVF	CAS2M,W		;data
	CALL	EWrite		;zpis
	GOTO	NCAS2
;--------------------------------
;nadpis [2.rEF.] 2.referenn teplota pro 2.as
NREF2	MOVLW	0x82		;2.
	MOVWF	Znak3
	MOVLW	0x19		;r
	MOVWF	Znak2
	MOVLW	0x0E		;E
	MOVWF	Znak1
	MOVLW	0x8F		;F.
	MOVWF	Znak0
	CALL	TNS		;test neco stisknuto?
;zobrazit REF2
ZREF2	MOVF	REF21,W		;referenn teplota pro as 2
	MOVWF	A1
	MOVF	REF22,W
	MOVWF	A2
	CALL	HEXDEC

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto
	GOTO	ZREF2		;NE
	BTFSS	KLVP,TlM	;stisknuto?
	GOTO	NCAS2		;ANO, minul
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	NCAS3		;ANO, dal

	MOVLW	0x82		;2.
	MOVWF	Znak3
	MOVLW	0x19		;r
	MOVWF	Znak2
	MOVLW	0x0E		;E
	MOVWF	Znak1
	MOVLW	0x8F		;F.
	MOVWF	Znak0
;pauza pro S
	CLRWDT
	BTFSC	KLVP,TlS	;stisknuto?
	GOTO	ZREF2		;NE
	BTFSS	FL,Znova	;odcasovano?
	GOTO	$-4		;NE
	BCF	FL,Znova	;nulovat
;vloit REF2
EREF2
;blikat REF2
	BTFSS	BLIK,4
	GOTO	$+7
	MOVLW	0x20		;VYP
	MOVWF	Znak3		; displej
	MOVWF	Znak2		;
	MOVWF	Znak1		;
	MOVWF	Znak0		;
	GOTO	$+6
	MOVF	REF21,W		;ref.teplota pro as 2
	MOVWF	A1		;
	MOVF	REF22,W		;
	MOVWF	A2		;
	CALL	HEXDEC

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	EREF2		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	Z2REE		;ANO
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	PREF2		;ANO
;REF2 -1
	MOVF	REF21,W
	MOVWF	X1
	MOVF	REF22,W
	MOVWF	X2
	CALL	XM1
	MOVF	X1,W
	MOVWF	REF21
	MOVF	X2,W
	MOVWF	REF22
	GOTO	EREF2
;REF2 +1
PREF2	MOVF	REF21,W
	MOVWF	X1
	MOVF	REF22,W
	MOVWF	X2
	CALL	XP1
	MOVF	X1,W
	MOVWF	REF21
	MOVF	X2,W
	MOVWF	REF22
	GOTO	EREF2
;zpis 2.REF do EEPROM
Z2REE	MOVLW	0x0C		;adresa
	MOVWF	EEADRp		;
	MOVF	REF21,W		;data
	CALL	EWrite		;zpis
	INCF	EEADRp,F	;adresa+1
	MOVF	REF22,W		;data
	CALL	EWrite		;zpis
	GOTO	NREF2
;--------------------------------
;nadpis [3.CAS] 3.as pro zmnu ref. teploty
NCAS3	MOVLW	0x83		;3.
	MOVWF	Znak3
	MOVLW	0x0C		;C
	MOVWF	Znak2
	MOVLW	0x0A		;A
	MOVWF	Znak1
	MOVLW	0x05		;S
	MOVWF	Znak0
	CALL	TNS		;test neco stisknuto?
;zobrazit CAS3H
ZC3	MOVF	CAS3H,W		;as 3 hodiny
	CALL	CHD
	BTFSC	STATUS,Z	;C=0? nenulove
	MOVLW	0x20		;nezobrazovat nulu
	MOVWF	Znak3
	MOVF	R1,W
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2
;zobrazit CAS3M
	MOVF	CAS3M,W		;as 3 minuty
	CALL	CHD
	MOVWF	Znak1
	MOVF	R1,W
	MOVWF	Znak0

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto
	GOTO	ZC3		;NE
	BTFSS	KLVP,TlM	;stisknuto?
	GOTO	NREF2		;ANO, minul
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	NREF3		;ANO, dal

	MOVLW	0x83		;3.
	MOVWF	Znak3
	MOVLW	0x0C		;C
	MOVWF	Znak2
	MOVLW	0x0A		;A
	MOVWF	Znak1
	MOVLW	0x05		;S
	MOVWF	Znak0
;pauza pro S
	CLRWDT
	BTFSC	KLVP,TlS	;stisknuto?
	GOTO	ZC3		;NE
	BTFSS	FL,Znova	;odcasovano?
	GOTO	$-4		;NE
	BCF	FL,Znova	;nulovat
;vloit CAS3H
ECAS3H
;blikat CAS3H
	BTFSS	BLIK,4
	GOTO	$+6
	MOVLW	0x20		;VYP
	MOVWF	Znak3		; displej
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2		;
	GOTO	$+7
	MOVF	CAS3H,W		;as 3 Hod
	CALL	CHD		;vrati R1,R10=W
	MOVWF	Znak3		;Hod 3 desitky
	MOVF	R1,W		;rad jednicek
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2		;Hod 3 jednicky
;zobrazit CAS3M
	MOVF	CAS3M,W		;as 3 Min
	CALL	CHD
	MOVWF	Znak1		;Min 3 desitky
	MOVF	R1,W		;rad jednicek
	MOVWF	Znak0		;Min 3 jednicky

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	ECAS3H		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	ECAS3M		;ANO
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	PCAS3H		;ANO
;as 3 Hod -1
	MOVLW	1
	SUBWF	CAS3H,F		;as 3 Hod-1
	BTFSC	STATUS,C	;zporn?
	GOTO	ECAS3H		;NE
	MOVLW	23
	MOVWF	CAS3H
	GOTO	ECAS3H
;as 3 Hod +1
PCAS3H	INCF	CAS3H,F		;as 3 Hod+1
	MOVF	CAS3H,W
	SUBLW	23		;23-CAS1H
	BTFSS	STATUS,C	;C=1? kladne
	CLRF	CAS3H		;NE;=0
	GOTO	ECAS3H
;vloit CAS3M
ECAS3M
;zobrazit CAS3H
	MOVF	CAS3H,W		;as 3 Hod
	CALL	CHD		;vrati R1,R10=W
	MOVWF	Znak3		;Hod 3 desitky
	MOVF	R1,W		;rad jednicek
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2		;Hod 3 jednicky
;blikat CAS3M
	BTFSS	BLIK,4
	GOTO	$+5
	MOVLW	0x20		;VYP
	MOVWF	Znak1		; displej
	MOVWF	Znak0		;
	GOTO	$+6
	MOVF	CAS3M,W		;as 3 Min
	CALL	CHD
	MOVWF	Znak1		;Min 3 desitky
	MOVF	R1,W		;rad jednicek
	MOVWF	Znak0		;Min 3 jednicky

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	ECAS3M		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	Z3CEE		;ANO
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	PCAS3M		;ANO
;as 3 Min -1
	MOVLW	1
	SUBWF	CAS3M,F		;as 3 Min-1
	BTFSC	STATUS,C	;zporn?
	GOTO	ECAS3M		;NE
	MOVLW	59
	MOVWF	CAS3M
	GOTO	ECAS3M
;as 3 Min +1
PCAS3M	INCF	CAS3M,F		;as 3 Min+1
	MOVF	CAS3M,W
	SUBLW	59		;23-CAS3M
	BTFSS	STATUS,C	;C=1? kladne
	CLRF	CAS3M		;NE;=0
	GOTO	ECAS3M
;zpis 3.as do EEPROM
Z3CEE	MOVLW	0x0E		;adresa
	MOVWF	EEADRp		;
	MOVF	CAS3H,W		;data
	CALL	EWrite		;zpis
	INCF	EEADRp,F	;adresa+1
	MOVF	CAS3M,W		;data
	CALL	EWrite		;zpis
	GOTO	NCAS3
;--------------------------------
;nadpis [3.rEF.] 3.referenn teplota pro 3.as
NREF3	MOVLW	0x83		;3.
	MOVWF	Znak3
	MOVLW	0x19		;r
	MOVWF	Znak2
	MOVLW	0x0E		;E
	MOVWF	Znak1
	MOVLW	0x8F		;F.
	MOVWF	Znak0
	CALL	TNS		;test neco stisknuto?
;zobrazit REF3
ZREF3	MOVF	REF31,W		;referenn teplota pro as 3
	MOVWF	A1
	MOVF	REF32,W
	MOVWF	A2
	CALL	HEXDEC

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto
	GOTO	ZREF3		;NE
	BTFSS	KLVP,TlM	;stisknuto?
	GOTO	NCAS3		;ANO, minul
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	NCAS4		;ANO, dal

	MOVLW	0x83		;3.
	MOVWF	Znak3
	MOVLW	0x19		;r
	MOVWF	Znak2
	MOVLW	0x0E		;E
	MOVWF	Znak1
	MOVLW	0x8F		;F.
	MOVWF	Znak0
;pauza pro S
	CLRWDT
	BTFSC	KLVP,TlS	;stisknuto?
	GOTO	ZREF3		;NE
	BTFSS	FL,Znova	;odcasovano?
	GOTO	$-4		;NE
	BCF	FL,Znova	;nulovat
;vloit REF3
EREF3
;blikat REF3
	BTFSS	BLIK,4
	GOTO	$+7
	MOVLW	0x20		;VYP
	MOVWF	Znak3		; displej
	MOVWF	Znak2		;
	MOVWF	Znak1		;
	MOVWF	Znak0		;
	GOTO	$+6
	MOVF	REF31,W		;ref.teplota pro as 3
	MOVWF	A1		;
	MOVF	REF32,W		;
	MOVWF	A2		;
	CALL	HEXDEC

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	EREF3		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	Z3REE		;ANO
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	PREF3		;ANO
;REF3 -1
	MOVF	REF31,W
	MOVWF	X1
	MOVF	REF32,W
	MOVWF	X2
	CALL	XM1
	MOVF	X1,W
	MOVWF	REF31
	MOVF	X2,W
	MOVWF	REF32
	GOTO	EREF3
;REF3 +1
PREF3	MOVF	REF31,W
	MOVWF	X1
	MOVF	REF32,W
	MOVWF	X2
	CALL	XP1
	MOVF	X1,W
	MOVWF	REF31
	MOVF	X2,W
	MOVWF	REF32
	GOTO	EREF3
;zpis 3.REF do EEPROM
Z3REE	MOVLW	0x10		;adresa
	MOVWF	EEADRp		;
	MOVF	REF31,W		;data
	CALL	EWrite		;zpis
	INCF	EEADRp,F	;adresa+1
	MOVF	REF32,W		;data
	CALL	EWrite		;zpis
	GOTO	NREF3
;--------------------------------
;nadpis [4.CAS] 4.as pro zmnu ref. teploty
NCAS4	MOVLW	0x84		;4.
	MOVWF	Znak3
	MOVLW	0x0C		;C
	MOVWF	Znak2
	MOVLW	0x0A		;A
	MOVWF	Znak1
	MOVLW	0x05		;S
	MOVWF	Znak0
	CALL	TNS		;test neco stisknuto?
;zobrazit CAS4H
ZC4	MOVF	CAS4H,W		;as 4 hodiny
	CALL	CHD
	BTFSC	STATUS,Z	;C=0? nenulove
	MOVLW	0x20		;nezobrazovat nulu
	MOVWF	Znak3
	MOVF	R1,W
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2
;zobrazit CAS4M
	MOVF	CAS4M,W		;as 4 minuty
	CALL	CHD
	MOVWF	Znak1
	MOVF	R1,W
	MOVWF	Znak0

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto
	GOTO	ZC4		;NE
	BTFSS	KLVP,TlM	;stisknuto?
	GOTO	NREF3		;ANO, minul
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	NREF4		;ANO, dal

	MOVLW	0x84		;4.
	MOVWF	Znak3
	MOVLW	0x0C		;C
	MOVWF	Znak2
	MOVLW	0x0A		;A
	MOVWF	Znak1
	MOVLW	0x05		;S
	MOVWF	Znak0
;pauza pro S
	CLRWDT
	BTFSC	KLVP,TlS	;stisknuto?
	GOTO	ZC4		;NE
	BTFSS	FL,Znova	;odcasovano?
	GOTO	$-4		;NE
	BCF	FL,Znova	;nulovat
;vloit CAS4H
ECAS4H
;blikat CAS4H
	BTFSS	BLIK,4
	GOTO	$+6
	MOVLW	0x20		;VYP
	MOVWF	Znak3		; displej
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2		;
	GOTO	$+7
	MOVF	CAS4H,W		;as 4 Hod
	CALL	CHD		;vrati R1,R10=W
	MOVWF	Znak3		;Hod 4 desitky
	MOVF	R1,W		;rad jednicek
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2		;Hod 4 jednicky
;zobrazit CAS4M
	MOVF	CAS4M,W		;as 4 Min
	CALL	CHD
	MOVWF	Znak1		;Min 4 desitky
	MOVF	R1,W		;rad jednicek
	MOVWF	Znak0		;Min 4 jednicky

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	ECAS4H		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	ECAS4M		;ANO
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	PCAS4H		;ANO
;as 4 Hod -1
	MOVLW	1
	SUBWF	CAS4H,F		;as 4 Hod-1
	BTFSC	STATUS,C	;zporn?
	GOTO	ECAS4H		;NE
	MOVLW	23
	MOVWF	CAS4H
	GOTO	ECAS4H
;as 4 Hod +1
PCAS4H	INCF	CAS4H,F		;as 4 Hod+1
	MOVF	CAS4H,W
	SUBLW	23		;23-CAS4H
	BTFSS	STATUS,C	;C=1? kladne
	CLRF	CAS4H		;NE;=0
	GOTO	ECAS4H
;vloit CAS4M
ECAS4M
;zobrazit CAS4H
	MOVF	CAS4H,W		;as 4 Hod
	CALL	CHD		;vrati R1,R10=W
	MOVWF	Znak3		;Hod 4 desitky
	MOVF	R1,W		;rad jednicek
	IORLW	B'10000000'	;ZAP teku
	MOVWF	Znak2		;Hod 4 jednicky
;blikat CAS4M
	BTFSS	BLIK,4
	GOTO	$+5
	MOVLW	0x20		;VYP
	MOVWF	Znak1		; displej
	MOVWF	Znak0		;
	GOTO	$+6
	MOVF	CAS4M,W		;as 4 Min
	CALL	CHD
	MOVWF	Znak1		;Min 4 desitky
	MOVF	R1,W		;rad jednicek
	MOVWF	Znak0		;Min 4 jednicky

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	ECAS4M		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	Z4CEE		;ANO
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	PCAS4M		;ANO
;as 4 Min -1
	MOVLW	1
	SUBWF	CAS4M,F		;as 4 Min-1
	BTFSC	STATUS,C	;zporn?
	GOTO	ECAS4M		;NE
	MOVLW	59
	MOVWF	CAS4M
	GOTO	ECAS4M
;as 4 Min +1
PCAS4M	INCF	CAS4M,F		;as 4 Min+1
	MOVF	CAS4M,W
	SUBLW	59		;23-CAS4M
	BTFSS	STATUS,C	;C=1? kladne
	CLRF	CAS4M		;NE;=0
	GOTO	ECAS4M
;zpis 4.as do EEPROM
Z4CEE	MOVLW	0x12		;adresa
	MOVWF	EEADRp		;
	MOVF	CAS4H,W		;data
	CALL	EWrite		;zpis
	INCF	EEADRp,F	;adresa+1
	MOVF	CAS4M,W		;data
	CALL	EWrite		;zpis
	GOTO	NCAS4
;--------------------------------
;nadpis [4.rEF.] 4.referenn teplota pro 4.as
NREF4	MOVLW	0x84		;4.
	MOVWF	Znak3
	MOVLW	0x19		;r
	MOVWF	Znak2
	MOVLW	0x0E		;E
	MOVWF	Znak1
	MOVLW	0x8F		;F.
	MOVWF	Znak0
	CALL	TNS		;test neco stisknuto?
;zobrazit REF4
ZREF4	MOVF	REF41,W		;referenn teplota pro as 4
	MOVWF	A1
	MOVF	REF42,W
	MOVWF	A2
	CALL	HEXDEC

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto
	GOTO	ZREF4		;NE
	BTFSS	KLVP,TlM	;stisknuto?
	GOTO	NCAS4		;ANO, minul
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	NRUP		;ANO, dal

	MOVLW	0x84		;4.
	MOVWF	Znak3
	MOVLW	0x19		;r
	MOVWF	Znak2
	MOVLW	0x0E		;E
	MOVWF	Znak1
	MOVLW	0x8F		;F.
	MOVWF	Znak0
;pauza pro S
	CLRWDT
	BTFSC	KLVP,TlS	;stisknuto?
	GOTO	ZREF4		;NE
	BTFSS	FL,Znova	;odcasovano?
	GOTO	$-4		;NE
	BCF	FL,Znova	;nulovat
;vloit REF4
EREF4
;blikat REF4
	BTFSS	BLIK,4
	GOTO	$+7
	MOVLW	0x20		;VYP
	MOVWF	Znak3		; displej
	MOVWF	Znak2		;
	MOVWF	Znak1		;
	MOVWF	Znak0		;
	GOTO	$+6
	MOVF	REF41,W		;ref.teplota pro as 4
	MOVWF	A1		;
	MOVF	REF42,W		;
	MOVWF	A2		;
	CALL	HEXDEC

	CALL	KLVM		;KLV test + Men
	BTFSC	STATUS,Z	;Z=0? neco stisknuto?
	GOTO	EREF4		;NE
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	Z4REE		;ANO
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	PREF4		;ANO
;REF4 -1
	MOVF	REF41,W
	MOVWF	X1
	MOVF	REF42,W
	MOVWF	X2
	CALL	XM1
	MOVF	X1,W
	MOVWF	REF41
	MOVF	X2,W
	MOVWF	REF42
	GOTO	EREF4
;REF4 +1
PREF4	MOVF	REF41,W
	MOVWF	X1
	MOVF	REF42,W
	MOVWF	X2
	CALL	XP1
	MOVF	X1,W
	MOVWF	REF41
	MOVF	X2,W
	MOVWF	REF42
	GOTO	EREF4
;zpis 4.REF do EEPROM
Z4REE	MOVLW	0x14		;adresa
	MOVWF	EEADRp		;
	MOVF	REF41,W		;data
	CALL	EWrite		;zpis
	INCF	EEADRp,F	;adresa+1
	MOVF	REF42,W		;data
	CALL	EWrite		;zpis
	GOTO	NREF4
;--------------------------------
;nadpis [ru.P. ] run provoz
NRUP	MOVLW	0x19		;r
	MOVWF	Znak3
	MOVLW	0x9C		;u.
	MOVWF	Znak2
	MOVLW	0x98		;P.
	MOVWF	Znak1
	MOVLW	0x20		;
	MOVWF	Znak0
	CALL	TNS		;test neco stisknuto?
;zobrazit run provoz
ZRUP	MOVLW	0x01
	BTFSS	PORTB,Re
	CLRW
	MOVWF	Znak0

	CALL	KLV
	BTFSC	STATUS,Z	;neco stisknuto?
	GOTO	$-2		;nic
	BTFSS	KLVP,TlM	;stisknuto?
	GOTO	NREF4		;ANO, pedchoz
	BTFSS	KLVP,TlP	;stisknuto?
	GOTO	NT		;ANO, zatek

	MOVLW	0x20		;
	MOVWF	Znak0
;pauza pro S
	CLRWDT
	BTFSC	KLVP,TlS	;stisknuto?
	GOTO	NRUP		;NE
	BTFSS	FL,Znova	;odasovno?
	GOTO	$-4		;NE
	BCF	FL,Znova

ZVR	CLRW			;ZAP Dis0,1
	BTFSS	BLIK,4
	GOTO	$+4

	MOVLW	0x20		;VYP Dis0,1
	MOVWF	Znak0		;
	GOTO	$+4

	BTFSC	PORTB,Re	;=0?
	MOVLW	0x01		;NE
	MOVWF	Znak0		;

	CALL	KLV
	BTFSC	STATUS,Z	;Z=0? neco stisknuto
	GOTO	ZVR		;nic
	BTFSS	KLVP,TlS	;stisknuto?
	GOTO	ZRUP		;ANO
;Re ZAP/VYP
	BTFSS	PORTB,Re
	GOTO	$+3
	BCF	PORTB,Re	;=0
	GOTO	ZVR
	BSF	PORTB,Re	;=1
	GOTO	ZVR
;================================
;ref.teplota RT1,2 do A
RTA	MOVF	RT1,W
	MOVWF	A1
	MOVF	RT2,W
	GOTO	WA2
;--------------------------------
;ref.teplota RT1,2 do B
RTB	MOVF	RT1,W
	MOVWF	B1
	MOVF	RT2,W
	GOTO	WB2
;--------------------------------
;teplota T1,2 do A
TA	MOVF	T1,W
	MOVWF	A1
	MOVF	T2,W
WA2	MOVWF	A2
	RETURN
;--------------------------------
;teplota T1,2 do B
TB	MOVF	T1,W
	MOVWF	B1
	MOVF	T2,W
WB2	MOVWF	B2
	RETURN
;--------------------------------
;Test A < B ; sC=0=ANO, 1=NE
TAB	MOVF	A2,W
	XORWF	B2,W		;(stejn=0)
	ANDLW	0x80		;10000000(1a1=1)
	BTFSC	STATUS,Z	;jin? (1)
	GOTO	$+3
	RLF	B2,W		;vlevo(sC=MSB)
	RETURN
;Test A = B ; sC=0=ANO
	CLRF	A3
	CLRF	B3
	CALL	MINUS		;A-B=C; sC=0=zporn vsledek
	CALL	TC0		;test C=0, sZ=1=ANO 0=NE
	BTFSC	STATUS,Z	;nenulov?
	BCF	STATUS,C	;sC=0 (A=B) jako zporn
	RETURN
;--------------------------------
;porucha snmae
ES	BCF	PORTB,Re	;Re=0, VYP rele
	RETURN
;--------------------------------
;Program Regulace
PR
;Re=1 pi, teplota < ref.teplota 
	CALL	RTA		;ref.teplota RT1,2 do A
	CALL	TB		;teplota T1,2 do B
	CALL	TAB		;Test A <= B ; sC=0=ANO, 1=NE
	BTFSC	STATUS,C	;
	BSF	PORTB,Re	;NE, Re=1, ZAP rele

;Re=0 pi, teplota >= ref.teplota+hystereze
	CALL	RTA		;ref.teplota RT1,2 do A
	MOVF	HYST,W		;hystereze
	ADDWF	A1,F		;HYST+A1=A1
	BTFSC	STATUS,C	;nepeteklo?
	INCF	A2,F		;+1
	CALL	TB		;teplota T1,2 do B
	CALL	TAB		;Test A <= B ; sC=0=ANO, 1=NE
	BTFSS	STATUS,C	;
	BCF	PORTB,Re	;ANO, Re=0, VYP rele

;................................
	RETURN
;--------------------------------
  	END
